package game;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.File;

import editor.CustomAnimationPanel;
import editor.PlayerCharacterEditorPanel;

public class CustomPlayableCharacterData {
	
	private char activationKey;
	
	private int maxHp;
	private int currentHp;
	
	private CustomImageDataII leftWalkAnimation[];
	private CustomImageDataII leftStandAnimation[];
	private CustomImageDataII leftAirAnimation[];
	
	private CustomImageDataII rightWalkAnimation[];
	private CustomImageDataII rightStandAnimation[];
	private CustomImageDataII rightAirAnimation[];
	
	private CustomImageDataII bulletAnimation[];
	
	private int attackPower;
	
	private int speed;
	
	private int hitboxWidth;
	private int hitboxHeight;
	private int hitboxYOffset;
	
	private String name;
	
	private CustomImageDataII faceplate;
	
	private Color textColor;
	private Color boardColor;
	
	
	private int animationIndex;
	
	private boolean shotsShouldSpread;
	private boolean shotsShouldSpawnHearts;
	
	private int bulletSpawnXOffset;
	private int bulletSpawnYOffset;
	
	
	
	private CustomPlayableCharacterData() {
		
	}
	
	public static CustomPlayableCharacterData readFromFile(BufferedReader in, ImageObserver io, char theActivationKey) throws Exception{
		
		
		
		CustomPlayableCharacterData returnValue = new CustomPlayableCharacterData();
		
		returnValue.activationKey = theActivationKey;
		
		String inputter;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("#"))
				continue;
			
			if(inputter.trim().equalsIgnoreCase("/character")) {
				return returnValue;
			}
			
			if(inputter.trim().contains("HitBoxWidth:")) {
				returnValue.hitboxWidth = Integer.parseInt(inputter.substring(12).trim());
			} else if(inputter.trim().contains("HitBoxHeight:")) {
				returnValue.hitboxHeight = Integer.parseInt(inputter.substring(13).trim());
			} else if(inputter.trim().contains("HitBoxYOffset:")) {
				returnValue.hitboxYOffset = Integer.parseInt(inputter.substring(14).trim());
			} else if(inputter.trim().contains("CharName:")) {
				returnValue.name = inputter.substring(9);
			} else if(inputter.trim().contains("Speed:")) {
				returnValue.speed = Integer.parseInt(inputter.substring(6).trim());
			} else if(inputter.trim().contains("Health:")) {
				returnValue.maxHp = Integer.parseInt(inputter.substring(7).trim());
				returnValue.currentHp = returnValue.maxHp;
			} else if(inputter.trim().contains("FaceplateTextColor:")) {
				returnValue.textColor = CustomAnimationPanel.convertStringToColor(inputter.substring(19).trim());
			} else if(inputter.trim().contains("FaceplateBgColor:")) {
				returnValue.boardColor = CustomAnimationPanel.convertStringToColor(inputter.substring(17).trim());
			} else if(inputter.trim().contains("FaceplateImage:")) {
				returnValue.faceplate = new CustomImageDataII(new File(inputter.substring(15).trim()), null, io, 50, 50);
			} else if(inputter.trim().contains("LeftStandAnim:")) {
				
				int frameCount = Integer.parseInt(inputter.substring(14).trim());
				
				returnValue.leftStandAnimation = new CustomImageDataII[frameCount];
				
				for(int i = 0; i < frameCount; i++) {
					inputter = in.readLine();
					if(inputter == null)
						return returnValue;
					
					returnValue.leftStandAnimation[i] = PlayerCharacterEditorPanel.convertStringToImage(inputter, io);
				}
				
			} else if(inputter.trim().contains("LeftWalkAnim:")) {
				
				int frameCount = Integer.parseInt(inputter.substring(13).trim());
				
				returnValue.leftWalkAnimation = new CustomImageDataII[frameCount];
				
				for(int i = 0; i < frameCount; i++) {
					inputter = in.readLine();
					if(inputter == null)
						return returnValue;
					
					returnValue.leftWalkAnimation[i] = PlayerCharacterEditorPanel.convertStringToImage(inputter, io);
				}
				
			} else if(inputter.trim().contains("LeftAirAnim:")) {
				
				int frameCount = Integer.parseInt(inputter.substring(12).trim());
				
				returnValue.leftAirAnimation = new CustomImageDataII[frameCount];
				
				for(int i = 0; i < frameCount; i++) {
					inputter = in.readLine();
					if(inputter == null)
						return returnValue;
					
					returnValue.leftAirAnimation[i] = PlayerCharacterEditorPanel.convertStringToImage(inputter, io);
				}
				
			} else if(inputter.trim().contains("RightStandAnim:")) {
				
				int frameCount = Integer.parseInt(inputter.substring(15).trim());
				
				returnValue.rightStandAnimation = new CustomImageDataII[frameCount];
				
				for(int i = 0; i < frameCount; i++) {
					inputter = in.readLine();
					if(inputter == null)
						return returnValue;
					
					returnValue.rightStandAnimation[i] = PlayerCharacterEditorPanel.convertStringToImage(inputter, io);
				}
				
			} else if(inputter.trim().contains("RightWalkAnim:")) {
				
				int frameCount = Integer.parseInt(inputter.substring(14).trim());
				
				returnValue.rightWalkAnimation = new CustomImageDataII[frameCount];
				
				for(int i = 0; i < frameCount; i++) {
					inputter = in.readLine();
					if(inputter == null)
						return returnValue;
					
					returnValue.rightWalkAnimation[i] = PlayerCharacterEditorPanel.convertStringToImage(inputter, io);
				}
				
			} else if(inputter.trim().contains("RightAirAnim:")) {
				
				int frameCount = Integer.parseInt(inputter.substring(13).trim());
				
				returnValue.rightAirAnimation = new CustomImageDataII[frameCount];
				
				for(int i = 0; i < frameCount; i++) {
					inputter = in.readLine();
					if(inputter == null)
						return returnValue;
					
					returnValue.rightAirAnimation[i] = PlayerCharacterEditorPanel.convertStringToImage(inputter, io);
				}
				
			} else if(inputter.trim().contains("BulletAnim:")) {
				
				int frameCount = Integer.parseInt(inputter.substring(11).trim());
				
				returnValue.bulletAnimation = new CustomImageDataII[frameCount];
				
				for(int i = 0; i < frameCount; i++) {
					inputter = in.readLine();
					if(inputter == null)
						return returnValue;
					
					returnValue.bulletAnimation[i] = PlayerCharacterEditorPanel.convertStringToImage(inputter, io);
				}
				
			} else if(inputter.trim().contains("Attack:")) {
				returnValue.attackPower = Integer.parseInt(inputter.substring(7).trim());
			} else if(inputter.trim().contains("NoSpread")) {
				returnValue.shotsShouldSpread = false;
			} else if(inputter.trim().contains("Spread")) {
				returnValue.shotsShouldSpread = true;
			} else if(inputter.trim().contains("NoMedic")) {
				returnValue.shotsShouldSpawnHearts = false;
			} else if(inputter.trim().contains("Medic")) {
				returnValue.shotsShouldSpawnHearts = true;
			} else if(inputter.trim().contains("BulletSpawnXOffset:")) {
				returnValue.bulletSpawnXOffset = Integer.parseInt(inputter.substring(19).trim());
			} else if(inputter.trim().contains("BulletSpawnYOffset:")) {
				returnValue.bulletSpawnYOffset = Integer.parseInt(inputter.substring(19).trim());
			}
			
			
		}
		
		
		
		
		return returnValue;
		
	}

	public int getMaxHp() {
		return maxHp;
	}

	public int getCurrentHp() {
		return currentHp;
	}

	public CustomImageDataII[] getLeftWalkAnimation() {
		return leftWalkAnimation;
	}

	public CustomImageDataII[] getLeftStandAnimation() {
		return leftStandAnimation;
	}

	public CustomImageDataII[] getLeftAirAnimation() {
		return leftAirAnimation;
	}

	public CustomImageDataII[] getRightWalkAnimation() {
		return rightWalkAnimation;
	}

	public CustomImageDataII[] getRightStandAnimation() {
		return rightStandAnimation;
	}

	public CustomImageDataII[] getRightAirAnimation() {
		return rightAirAnimation;
	}

	public CustomImageDataII[] getBulletAnimation() {
		return bulletAnimation;
	}

	public int getAttackPower() {
		return attackPower;
	}

	public int getSpeed() {
		return speed;
	}

	public int getHitboxWidth() {
		return hitboxWidth;
	}

	public int getHitboxHeight() {
		return hitboxHeight;
	}

	public int getHitboxYOffset() {
		return hitboxYOffset;
	}

	public String getName() {
		return name;
	}

	public CustomImageDataII getFaceplate() {
		return faceplate;
	}

	public Color getTextColor() {
		return textColor;
	}

	public Color getBoardColor() {
		return boardColor;
	}

	public int getAnimationIndex() {
		return animationIndex;
	}

	public boolean isShotsShouldSpread() {
		return shotsShouldSpread;
	}

	public boolean isShotsShouldSpawnHearts() {
		return shotsShouldSpawnHearts;
	}

	public int getBulletSpawnXOffset() {
		return bulletSpawnXOffset;
	}

	public int getBulletSpawnYOffset() {
		return bulletSpawnYOffset;
	}
	
	public char getActivationKey() {
		return activationKey;
	}
	
	public void heal() {
		this.currentHp++;
		if(this.currentHp > this.maxHp)
			this.currentHp = this.maxHp;
	}
	
	public void healToMax() {
		this.currentHp = this.maxHp;
	}
	
	public boolean takeDamageReturnDied(int damage) {
		
		this.currentHp -= damage;
		
		return this.currentHp <= 0;
		
	}
	
	public void drawFaceplate(int xOffset, int yOffset, Graphics g, BufferedImage heartImage, BufferedImage brokenHeartImage, BufferedImage plusImage) {
		
		
		Color origColor = g.getColor();
		
		
		g.setColor(this.boardColor);
		
		g.fillRect(xOffset, yOffset, 100, 110);
		
		g.setColor(this.textColor);
		
		g.drawRect(xOffset, yOffset, 100, 110);
		
		faceplate.drawObjectFromUpperLeftCorner(g, xOffset + 5, yOffset + 6);
		
		
		
		if(this.maxHp > 0) {
			
			
			
//			System.out.println("<><>DELME numberOfWholeHearts: " + numberOfWholeHearts);
			
			BufferedImage tempImage;
			
			for(int j = 1; j <= 7; j++) {
				
				if(j > this.maxHp) {
					j = 8;
					continue;
				}
				
				if(j <= this.currentHp) {
					tempImage = heartImage;
				} else {
					tempImage = brokenHeartImage;
				}
				
				g.drawImage(tempImage, xOffset + (j % 2 != 0 ? 66 : 84), yOffset + ((j-1) / 2) * 14 + 1, null);
				
			}
			
			if(this.maxHp == 8) {
				
				if(this.currentHp < 8) {
					tempImage = brokenHeartImage;
				} else {
					tempImage = heartImage;
				}
				
				g.drawImage(tempImage,  xOffset + 84, yOffset + 43, null);
			}
			
			if(this.maxHp > 8) {
				
				if(this.currentHp > 8) {
					tempImage = plusImage;
				} else if(this.currentHp == 8) {
					tempImage = heartImage;
				} else {
					tempImage = brokenHeartImage;
				}
				
				g.drawImage(tempImage, xOffset + 84, yOffset + 43, null);
			}
			
		}
		
		
		Font origFont = g.getFont();
		
		Font newFont = new Font(origFont.getName(), Font.BOLD, 12);
		
		g.setFont(newFont);
		
		
		
		g.drawString(this.name, xOffset + 5, yOffset + 75);
		
		
		g.setFont(origFont);
		g.setColor(origColor);
		
	}
	
}
